﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="System.Diagnostics" %>
<%@ import Namespace="System.ComponentModel" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Place" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zestawienie dla GUS Z-06 (2006)</title>
		<script runat="server">

	static readonly int dataGraniczna = 18;	//XX.01.2005
	
	//Jeżeli ustawiony true, to wszystkie liczby podawane bez zaokrąglenia
    static bool debug = false;	
	
	//Po ustawieniu na true raport zostanie przygotowany dla pracowników zwróconych
	//przez listę a nie dla wszystkich
    static bool wglisty = false;	
	
    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = Date.Today;
            rok = data.Year;
            if (data.Month<7)
				rok --;
        }
    
        int rok;
        [Required]
        [Priority(1)]
        public int Rok {
            get { return rok; }
            set {				
                rok = value;
                OnChanged(EventArgs.Empty);
            }
        }
        
        [Priority(2)]
        public FromTo Okres {
			get { return FromTo.Year(rok); }
        }
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }
    
    class WynagrodzeniaBase {
    
		protected readonly FromTo rok;
		
		protected WynagrodzeniaBase(FromTo rok) {
			this.rok = rok;
		}
		
		ICollection AktualnyOkres(Pracownik p) {
			ArrayList result = new ArrayList();
			
			//Elementy za okres sprawozawczy wypłacone do 18 stycznia następnego roku
			SubTable st = PlaceModule.GetInstance(p).WypElementy.WgPracownik[p];
			st = new SubTable(st, rok);
			FromTo ow1 = new FromTo(rok.From, rok.To + dataGraniczna);
			foreach (WypElement e in st)
				if (ow1.Contains(e.Data))
					result.Add(e);
					
			return result;
		}
		
		ICollection PoparzedniOkres(Pracownik p) {
			ArrayList result = new ArrayList();
			
			//Wypłaty wypłacone po 18 stycznia okresu sprawozdawczego za okresy poprzednie
			FromTo ow1 = new FromTo(new Date(rok.From + dataGraniczna), Date.MaxValue);
			SubTable st = PlaceModule.GetInstance(p).WypElementy.WgDaty[p];
			st = new SubTable(st, ow1);
			FromTo ow2 = new FromTo(Date.MinValue, rok.From-1);
			foreach (WypElement e in st)
				if (ow2.Contains(e.Okres.To))
					result.Add(e);
					
			return result;
		}
		
		protected IEnumerable Elementy(Pracownik p) {
			ArrayList result = new ArrayList();
			result.AddRange(AktualnyOkres(p));
			result.AddRange(PoparzedniOkres(p));
			return result;
		}
		
		protected IEnumerable ElementyRok(Pracownik p) {
			SubTable st = PlaceModule.GetInstance(p).WypElementy.WgPracownik[p];
			return new SubTable(st, rok);
		}
    }
    
    class ZatrudnienieWynagrodzenie: WynagrodzeniaBase {
    
		public decimal[] etaty = new decimal[12];
		public decimal brutto;
		public decimal[] er = new decimal[12];
		public decimal br;
		public decimal[] eu = new decimal[12];
		public decimal bu;
		public decimal[] ez = new decimal[12];
		public decimal bz;
		public decimal zus;
		public decimal pit;
		public decimal[] ei = new decimal[12];
		public decimal bi;
		
		readonly Periods miesiące;
		
		public ZatrudnienieWynagrodzenie(FromTo rok): base(rok) {
			miesiące = Periods.New(rok).BreakByMonth();
		}
		
		public void AddEtaty(PracHistoria ph) {
			FromTo eo = ph.Etat.EfektywnyOkres;
			Periods ps = Periods.New(eo);
			KalkulatorPracy kp = new KalkulatorPracy(ph.Pracownik);
			foreach (INieobecnosc n in kp.Nieobecnosci(eo, true, Nieobecnosc.Przyczyna(PrzyczynaNieobecnosci.UrlopBezpłatny)))
				ps -= n.Okres;

			decimal w = (decimal)ph.Etat.Zaszeregowanie.Wymiar;
			if (w==0m)
				w = 1m;
			ps *= miesiące;
			foreach (FromTo ft in ps) {
				int m = ft.From.Month-1;
				int d = ft.Days;
				decimal e = w * d / miesiące[m].Days;
				
				switch (ph.Etat.RodzajZatrudnienia) {
					case RodzajZatrudnienia.NieDotyczy:
					case RodzajZatrudnienia.PracownikTymczasowy:
					case RodzajZatrudnienia.CzłonekRSP:
					case RodzajZatrudnienia.CzłonekSKR:
					case RodzajZatrudnienia.Student:
					case RodzajZatrudnienia.Absolwent:
						etaty[m] += e; 
						if (ph.GUS.StRobotnicze)
							er[m] += e;
						if (ph.GUS.PraceInterwencyjne)
							ei[m] += e;
						break;
										
					case RodzajZatrudnienia.Uczeń1Klasy:
					case RodzajZatrudnienia.Uczeń2Klasy:
					case RodzajZatrudnienia.Uczeń3Klasy:
					case RodzajZatrudnienia.MłodocianyPrzyuczany:
						eu[m] += e; break;
					
					case RodzajZatrudnienia.PracownikZaGranicą:
                    case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                        ez[m] += e; break;
				
					case RodzajZatrudnienia.Właściciel:
					case RodzajZatrudnienia.OsobaWspółpracująca:
					case RodzajZatrudnienia.Chałupnik:
					//Agent
						break;
									
					default:
						throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
				}
				
			}			
		}	
		
		public void AddBrutto(Pracownik p) {			
			foreach (WypElement e in Elementy(p))
				if (e.Wyplata.Typ!=TypWyplaty.Umowa 
                    && !e.ZasiłekBudżet 
                    && !e.ZasiłekZus 
                    && e.Definicja.Info.Opodatkowany
                    && e.Definicja.GUS.WykazujNaDeklaracjach
                )
					AddElement(e);					
		}

		void AddElement(WypElement e) {
			PracHistoria ph = e.PracHistoria;
			switch (ph.Etat.RodzajZatrudnienia) {
				case RodzajZatrudnienia.NieDotyczy:
                case RodzajZatrudnienia.PracownikTymczasowy:
				case RodzajZatrudnienia.CzłonekRSP:
				case RodzajZatrudnienia.CzłonekSKR:
				case RodzajZatrudnienia.Student:
				case RodzajZatrudnienia.Absolwent:
					brutto += e.Wartosc; 
					if (ph.GUS.StRobotnicze)
						br += e.Wartosc;
					if (ph.GUS.PraceInterwencyjne)
						bi += e.Wartosc;
					zus += e.Podatki.KosztyZUS;
					pit += e.Podatki.ZdrowotneDoOdliczenia + e.Podatki.ZalFIS;
					break;
									
				case RodzajZatrudnienia.Uczeń1Klasy:
				case RodzajZatrudnienia.Uczeń2Klasy:
				case RodzajZatrudnienia.Uczeń3Klasy:
				case RodzajZatrudnienia.MłodocianyPrzyuczany:
					bu += e.Wartosc;
					break;
				
				case RodzajZatrudnienia.PracownikZaGranicą:
                case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                    bz += e.Wartosc;
					break;
			
				case RodzajZatrudnienia.Właściciel:
				case RodzajZatrudnienia.OsobaWspółpracująca:
				case RodzajZatrudnienia.Chałupnik:					
				//Agent
					break;
			
				default:
					throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
			}
		}
    }

            class Minimalne {

                public int min1;
                public int min2;
                public int min3;
                readonly FromTo grudzień;

                public Minimalne(int rok) {
                    this.grudzień = FromTo.Month(rok, 12);
                }

                public void AddOsoba(Pracownik p) {
                    PracHistoria ph = p[grudzień.To];
                    if (!ph.Etat.EfektywnyOkres.Contains(grudzień.To))
                        return;

                    switch (ph.Etat.RodzajZatrudnienia) {
                        case RodzajZatrudnienia.NieDotyczy:
                        case RodzajZatrudnienia.PracownikTymczasowy:
                        case RodzajZatrudnienia.CzłonekRSP:
                        case RodzajZatrudnienia.CzłonekSKR:
                        case RodzajZatrudnienia.Student:
                        case RodzajZatrudnienia.Absolwent:
                            break;

                        case RodzajZatrudnienia.Uczeń1Klasy:
                        case RodzajZatrudnienia.Uczeń2Klasy:
                        case RodzajZatrudnienia.Uczeń3Klasy:
                        case RodzajZatrudnienia.MłodocianyPrzyuczany:
                        case RodzajZatrudnienia.PracownikZaGranicą:
                        case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                        case RodzajZatrudnienia.Właściciel:
                        case RodzajZatrudnienia.OsobaWspółpracująca:
                        case RodzajZatrudnienia.Chałupnik:
                            //Agent
                            return;

                        default:
                            throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
                    }

                    decimal we = (decimal)ph.Etat.Zaszeregowanie.Wymiar;
                    if (we == 0m)
                        we = 1;

                    PlaceModule płace = PlaceModule.GetInstance(p);
                    SubTable st = płace.WypElementy.WgPracownik[p];
                    st = new SubTable(st, grudzień);
                    decimal w = 0m;
                    foreach (WypElement e in st)
                        if (e.Definicja.MinimalneWynagrodzenie
                            && e.Definicja.GUS.WykazujNaDeklaracjach
                        )
                            w += e.Wartosc / we;

                    w = Soneta.Tools.Math.RoundCy(w);

                    if (w <= 936.00m) {
                        min1++;
                        
                        if (935.99m <= w)
                            min2++;
                        else if (748.80m <= w)
                            min3++;
                        
                    }
                }
            }
    
    class SkładnikiWynagrodzeń: WynagrodzeniaBase {
    
		public decimal brutto;
		public decimal nadliczbowe;
		public decimal chałupnicy;
		public decimal zysk;
		public decimal budżet;
		public decimal umowy;
		public decimal honoraria;
		public decimal prowizje;
		
		public SkładnikiWynagrodzeń(FromTo rok): base(rok) {
		}

        public void AddBrutto(Pracownik p) {
            decimal odchyłki = 0;
            Time czasNadgodzin = Time.Zero;
            Time czasOdchyłek = Time.Zero;

            foreach (WypElement e in Elementy(p)) {
                switch (e.Definicja.GUS.Kategoria) {
                    case KategoriaWynagrodzeniaGUS.NieWykazujNaDeklaracjach:
                        break;
                    case KategoriaWynagrodzeniaGUS.WypłataUdziałWZysku:
                        zysk += e.Wartosc; break;
                    case KategoriaWynagrodzeniaGUS.DodatkoweWynagrodzenieRoczne:
                        budżet += e.Wartosc; break;
                    case KategoriaWynagrodzeniaGUS.Honorarium:
                        honoraria += e.Wartosc; break;
                    case KategoriaWynagrodzeniaGUS.WynagrodzenieAkwizycyjnoProwizyjne:
                        prowizje += e.Wartosc; break;
                    case KategoriaWynagrodzeniaGUS.WgDefinicjiElementu:
                        if (e.Definicja.Info.Opodatkowany && !e.ZasiłekZus && !e.ZasiłekBudżet)
                            if (e.Wyplata.Typ == TypWyplaty.Umowa) {
                                if (Honorarium(e))
                                    honoraria += e.Wartosc;
                                else if (UmowaZlecenie(e))
                                    umowy += e.Wartosc;
                            }
                            else if (WchodziEtat(e)) {//Bez kontroli okresu zatrudnienia
                                brutto += e.Wartosc;
                                PracHistoria ph = e.PracHistoria;
                                if (ph.Etat.RodzajZatrudnienia == RodzajZatrudnienia.Chałupnik)
                                    chałupnicy += e.Wartosc;
                                //Wliczamy dopłaty do nadgodzin oraz odchyłki+ minu odchyłki- (min 0)
                                switch (e.RodzajZrodla) {
                                    case RodzajŹródłaWypłaty.NadgodzinyI:
                                    case RodzajŹródłaWypłaty.NadgodzinyII:
                                    case RodzajŹródłaWypłaty.NadgodzinyŚw:
                                        czasNadgodzin += e.Czas;
                                        nadliczbowe += e.Wartosc; 
                                        break;
                                    default:
                                        foreach (WypSkladnik s in e.Skladniki)
                                            switch (s.Rodzaj) {
                                                case RodzajSkładnikaWypłaty.OdchyłkaPlus:
                                                case RodzajSkładnikaWypłaty.OdchyłkaMinus:
                                                    czasOdchyłek += s.Czas;
                                                    odchyłki += s.Wartosc;
                                                    break;
                                            }
                                        break;
                                }
                            }
                        break;
                    default:
                        throw new Exception("Nieoczekiwana wartość pola e.Definicja.GUS.Kategoria: " + e.Definicja.GUS.Kategoria);
                }
            }

            if (odchyłki > 0) {
                if (Time.Zero < czasNadgodzin && czasNadgodzin < czasOdchyłek) 
                    odchyłki = Soneta.Tools.Math.RoundCy(odchyłki * (decimal)(czasNadgodzin / czasOdchyłek));

                nadliczbowe += odchyłki;
            }
        }
		
		bool WchodziEtat(WypElement e) {
			PracHistoria ph = e.PracHistoria;
			
			switch (ph.Etat.RodzajZatrudnienia) {
				case RodzajZatrudnienia.NieDotyczy:
                case RodzajZatrudnienia.PracownikTymczasowy:
				case RodzajZatrudnienia.CzłonekRSP:
				case RodzajZatrudnienia.CzłonekSKR:
				case RodzajZatrudnienia.Student:
				case RodzajZatrudnienia.Absolwent:
				case RodzajZatrudnienia.Chałupnik:
				case RodzajZatrudnienia.PracownikZaGranicą:
                case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                    return true;
									
				case RodzajZatrudnienia.Uczeń1Klasy:
				case RodzajZatrudnienia.Uczeń2Klasy:
				case RodzajZatrudnienia.Uczeń3Klasy:
				case RodzajZatrudnienia.MłodocianyPrzyuczany:
				case RodzajZatrudnienia.Właściciel:
				case RodzajZatrudnienia.OsobaWspółpracująca:
				//Agent
					return false;
			
				default:
					throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
			}
		}		
		
		bool Honorarium(WypElement e) {
			PozycjaPIT pit = e.Definicja.Deklaracje.PozycjaPIT;
			return pit!=null && pit.PIT8B==70;
		}
		
		bool UmowaZlecenie(WypElement e) {
			switch (e.Definicja.Deklaracje.Umowa) {
				case TypUmowyCywilnoPrawnej.UmowaODzieło:
				case TypUmowyCywilnoPrawnej.UmowaZlecenia:
					return true;
			}
			return false;
		}
    }
    
    class CzasPracy: WynagrodzeniaBase{
    
		public Time ogółem = Time.Zero;
		public Time nadlicz = Time.Zero;
		public Time nieobec = Time.Zero;
		public Time płatne = Time.Zero;
		public Time urlopy = Time.Zero;
		public Time choroby = Time.Zero;
		public Time rogółem = Time.Zero;
		public Time rnadlicz = Time.Zero;
		public Time rnieobec = Time.Zero;
		public Time rpłatne = Time.Zero;
		public Time rurlopy = Time.Zero;
		public Time rchoroby = Time.Zero;
		
		public CzasPracy(FromTo rok): base(rok) {
		}
		
		public void AddCzas(Pracownik p) {			
			foreach (WypElement e in Elementy(p))
				if (e.Wyplata.Typ!=TypWyplaty.Umowa 
                    && !e.ZasiłekZus 
                    && !e.ZasiłekBudżet 
                    && e.Definicja.Info.Opodatkowany
                    && e.Definicja.GUS.WykazujNaDeklaracjach
                    && WchodziEtat(e)
                )
					AddElement(e);					
		}

		void AddElement(WypElement e) {			
			Time czas = Time.Zero;
			Time nie = Time.Zero;
			Time nad = Time.Zero;
			Time nop = Time.Zero;
			Time nuw = Time.Zero;
			Time nch = Time.Zero;
			switch (e.RodzajZrodla) {
				case RodzajŹródłaWypłaty.Etat:
					foreach (WypSkladnik s in e.Skladniki) {
						if (s.Rodzaj!=RodzajSkładnikaWypłaty.OdchyłkaAkordMinus)
							czas += s.Czas;
						if (s is WypSkladnikPomniejszenie) {
							WypSkladnikPomniejszenie sn = (WypSkladnikPomniejszenie)s;
							//Wykazujemy również urlopy bezpłatne
							nie -= sn.Czas;
						}
					}
					break;
					
				case RodzajŹródłaWypłaty.Nieobecność:
					{
						Time t = e.Czas;
						if (t==Time.Zero) {
							KalkulatorPlanu kp = new KalkulatorPlanu(e.Pracownik);
							t = kp.Norma(e.Okres).Czas;
						}
						nop += t;
						WypElementNieobecność en = (WypElementNieobecność)e;

                        if (en.Nieobecność != null) {
                            switch (en.Nieobecność.Definicja.Przyczyna) {
                                case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                                case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                                case PrzyczynaNieobecnosci.UrlopRehabilitacyjny:
                                    if (!en.ZasiłekZus)
                                        nch += t;
                                    break;
                                case PrzyczynaNieobecnosci.UrlopWypoczynkowy:
                                    nuw += t;
                                    break;
                            }

                            bool pomniejsza = false;
                            foreach (WypSkladnik skl in en.Nieobecność.Pomniejszenia)
                                if (skl.Element.RodzajZrodla == RodzajŹródłaWypłaty.Etat) {
                                    pomniejsza = true;
                                    break;
                                }
                            if (!pomniejsza) {
                                czas -= t;
                                nie += t;
                            }
                        }
                        
					}
					break;
								
				case RodzajŹródłaWypłaty.NadgodzinyI:
				case RodzajŹródłaWypłaty.NadgodzinyII:
				case RodzajŹródłaWypłaty.NadgodzinyŚw:
					nad += e.Czas;
					break;
				
				default:
					return;
			}
			
			PracHistoria ph = e.PracHistoria;
			
			if (ph.GUS.StRobotnicze) {
				rogółem += czas;
				rnadlicz += nad;
				rnieobec += nie;
				rpłatne += nop;
				rurlopy += nuw;
				rchoroby += nch;
			}
			else {
				ogółem += czas;
				nadlicz += nad;
				nieobec += nie;
				płatne += nop;
				urlopy += nuw;
				choroby += nch;
			}
		}

		bool WchodziEtat(WypElement e) {
			PracHistoria ph = e.PracHistoria;
			switch (ph.Etat.RodzajZatrudnienia) {
				case RodzajZatrudnienia.NieDotyczy:
                case RodzajZatrudnienia.PracownikTymczasowy:
				case RodzajZatrudnienia.CzłonekRSP:
				case RodzajZatrudnienia.CzłonekSKR:
				case RodzajZatrudnienia.Student:
				case RodzajZatrudnienia.Absolwent:
					return true;
									
				case RodzajZatrudnienia.Uczeń1Klasy:
				case RodzajZatrudnienia.Uczeń2Klasy:
				case RodzajZatrudnienia.Uczeń3Klasy:
				case RodzajZatrudnienia.MłodocianyPrzyuczany:
				case RodzajZatrudnienia.PracownikZaGranicą:
                case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                case RodzajZatrudnienia.Właściciel:
				case RodzajZatrudnienia.OsobaWspółpracująca:
				case RodzajZatrudnienia.Chałupnik:					
				//Agent
					return false;
			
				default:
					throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
			}
		}		
    }
    
    class ZatrZwolBase {
    
		protected static void Inc(bool kobieta, ref int mężczyźni, ref int kobiety) {
			if (kobieta)
				kobiety++;
			else
				mężczyźni++;
		}
		
		protected static bool Nieobecny(Pracownik pracownik, int rok) {
			KalkulatorPracy kp = new KalkulatorPracy(pracownik);
			FromTo okres = new FromTo(new Date(rok, 10, 1), new Date(rok+1, 3, 31));
			Periods on = Periods.Empty;
			foreach (INieobecnosc n in kp.Nieobecnosci(okres, false))
				switch (n.Definicja.Przyczyna) {
					case PrzyczynaNieobecnosci.UrlopBezpłatny:
					case PrzyczynaNieobecnosci.UrlopWychowawczy:
					case PrzyczynaNieobecnosci.UrlopWychowawczyZUS:
						on += n.Okres;
						break;
				}
		
			on = on.ToFlat();		
			okres = on[new Date(rok, 12, 31)];
			if (okres==FromTo.Empty)
				return false;
			StazPracy sp = new StazPracy(okres, pracownik).Normalizuj();
			return sp.Lata>0 || sp.Miesiace>2;
		}
    }

	class MiejscePracy: IComparable {
	
		public int CompareTo(object obj) {
			MiejscePracy mp = (MiejscePracy)obj;
			int i = gmina.CompareTo(mp.gmina);
            if (i == 0)
                i = miasto.CompareTo(mp.miasto);
            if (i == 0)
                i = rodzaj.CompareTo(mp.rodzaj);
            return i;
		}

        public override int GetHashCode() {
            return gmina.GetHashCode() ^ miasto.GetHashCode() ^ rodzaj.GetHashCode();
        }

        public readonly string gmina;
        public readonly string rodzaj;
        public readonly bool miasto;
		public int razem, kobiety;
		
		public MiejscePracy(string gmina, string rodzaj, bool miasto) {
            this.gmina = gmina;
            this.rodzaj = rodzaj;
            this.miasto = miasto;
		}
		
		public void Add(PracHistoria ph) {
			if (ph.Plec==PłećOsoby.Kobieta)
				kobiety++;
			razem++;
		}
	}
    
    class Pracujący31XII: ZatrZwolBase {
    
		public int pracujący, pracującyK,
		główne, główneK,
		pełnozatrudnieni, pełnozatrudnieniK,
		niepełnozatrudnieni, niepełnozatrudnieniK,
		wlswsp, wlswspK,
		właściciele, właścicieleK,
		nakładcza, nakładczaK,
		rsp,rspK,
		wnocnej,wnocnejK,
		niepełnosprawni,niepełnosprawniK,
		cudzoziemcy,cudzoziemcyK,
		emrent,emrentK;
		
		readonly int rok;
		readonly Date data;
		
		public Hashtable miejsca = new Hashtable();
		MiejscePracy razem = new MiejscePracy("", "", false);
		
		public Pracujący31XII(int rok) {
			this.rok = rok;
			data = new Date(rok, 12, 31);
			miejsca.Add("", razem);
		}
		
		public void AddPracownik(Pracownik p) {
			AddPracownik(p[data]);
		}
		
		void AddPracownik(PracHistoria ph) {
			bool kobieta = ph.Plec==PłećOsoby.Kobieta;
			if (ph.Etat.EfektywnyOkres.Contains(data)) {
				switch (ph.Etat.RodzajZatrudnienia) {
					case RodzajZatrudnienia.NieDotyczy:
					case RodzajZatrudnienia.PracownikTymczasowy:
					case RodzajZatrudnienia.CzłonekRSP:
					case RodzajZatrudnienia.CzłonekSKR:
					case RodzajZatrudnienia.Student:
					case RodzajZatrudnienia.Absolwent:
					case RodzajZatrudnienia.Właściciel:
					case RodzajZatrudnienia.OsobaWspółpracująca:
					case RodzajZatrudnienia.Chałupnik:
					case RodzajZatrudnienia.PracownikZaGranicą:
                    case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                        //Agent
						break;
										
					case RodzajZatrudnienia.Uczeń1Klasy:
					case RodzajZatrudnienia.Uczeń2Klasy:
					case RodzajZatrudnienia.Uczeń3Klasy:
					case RodzajZatrudnienia.MłodocianyPrzyuczany:
						return;
					
					default:
						throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
				}
				if (!Nieobecny(ph.Pracownik, rok)) {
					Inc(kobieta, ref pracujący, ref pracującyK);
					if (ph.GUS.GlowneMiejscePracy) {
						Inc(kobieta, ref główne, ref główneK);						
						Wydzial wdz = !ph.Etat.PracownikZaGranicą ? ph.Etat.Wydzial : ph.Module.Wydzialy.Firma;
						string gmina = wdz.GUS.Gmina;
                        string rodzaj = wdz.GUS.Dzialalnosc;
                        bool miasto = wdz.GUS.MiastoWies == MiastoWieś.Miasto;
                        if (gmina == "")
                            gmina = "&nbsp;";
                        if (rodzaj == "")
                            rodzaj = "&nbsp;";
                        string key = gmina.ToUpper() + "|" + miasto + "|" + rodzaj.ToUpper();
						MiejscePracy msc = (MiejscePracy)miejsca[key];
						if (msc==null)
                            miejsca.Add(key, msc = new MiejscePracy(gmina, rodzaj, miasto));
						msc.Add(ph);
						razem.Add(ph);							
						
						if (ph.Etat.Zaszeregowanie.Wymiar==1)
							Inc(kobieta, ref pełnozatrudnieni, ref pełnozatrudnieniK);
						else
							Inc(kobieta, ref niepełnozatrudnieni, ref niepełnozatrudnieniK);
							
						switch (ph.Etat.RodzajZatrudnienia) {
							case RodzajZatrudnienia.Właściciel:
								Inc(kobieta, ref właściciele, ref właścicieleK);
								Inc(kobieta, ref wlswsp, ref wlswspK);
								break;
					
							case RodzajZatrudnienia.OsobaWspółpracująca:
								Inc(kobieta, ref wlswsp, ref wlswspK);
								break;
													
							case RodzajZatrudnienia.CzłonekRSP:
							case RodzajZatrudnienia.CzłonekSKR:
								Inc(kobieta, ref rsp, ref rspK);
								break;
							
							case RodzajZatrudnienia.Chałupnik:
								Inc(kobieta, ref nakładcza, ref nakładczaK);
								break;
							
							//Agenci
					
						}
						
						if (ph.GUS.PracaWNocy)
							Inc(kobieta, ref wnocnej, ref wnocnejK);
							
						if (ph.StopienNiepelnosp.Stopien!=StNiepełnosprawności.Brak)
							Inc(kobieta, ref niepełnosprawni, ref niepełnosprawniK);
							
						if (ph.Obywatelstwo.Nazwa!=Obywatelstwo.Polskie)
							Inc(kobieta, ref cudzoziemcy, ref cudzoziemcyK);
							
						if (ph.PrawoEmRent.Kod!=KodPrawaEmRent.Brak)
							Inc(kobieta, ref emrent, ref emrentK);
					}
				}
			}
		}
	}
	
	class PrzyczynaRU: IComparable {
	
		public int CompareTo(object obj) {
			PrzyczynaRU pru = (PrzyczynaRU)obj;
			return nazwa.CompareTo(pru.nazwa);
		}
	
		public readonly string nazwa;
		public int razem, kobiety;
		
		public PrzyczynaRU(string nazwa) {
			this.nazwa = nazwa;
		}
		
		public void Add(PracHistoria ph) {
			if (ph.Plec==PłećOsoby.Kobieta)
				kobiety++;
			razem++;
		}
	}
	
    class ZatrudnieniZwolnieni: ZatrZwolBase {
		readonly FromTo rok;
		readonly FromTo rokex;
		
		public int poprzednio, poprzednioK,
		przyjęci, przyjęciK,
		pierwsza, pierwszaK,
		wyższa, wyższaK,
		policealna, policealnaK,
		liceum, liceumK,
		zasadnicza, zasadniczaK,
		zurlopu, zurlopuK,
		pracował, pracowałK,
		pozostali, pozostaliK, 
		zwolnieni, zwolnieniK,
		naurlop, naurlopK;
		
		public Hashtable przyczyny = new Hashtable();
		
		public ZatrudnieniZwolnieni(FromTo rok) {
			this.rok = rok;
			this.rokex = new FromTo(rok.From-1, rok.To);
		}
		
		public void AddPracownik(Pracownik pracownik) {
			bool kobieta = pracownik.Last.Plec==PłećOsoby.Kobieta;
			Periods oz = Periods.Empty;
			foreach (PracHistoria ph in pracownik.Historia.GetIntersectedRows(rokex)) 
				if (ph.GUS.GlowneMiejscePracy /*&& !ph.GUS.SezonowyDorywczy*/ && ph.Etat.Zaszeregowanie.Wymiar==1) {
					switch (ph.Etat.RodzajZatrudnienia) {
						case RodzajZatrudnienia.NieDotyczy:
						case RodzajZatrudnienia.PracownikTymczasowy:
						case RodzajZatrudnienia.CzłonekRSP:
						case RodzajZatrudnienia.CzłonekSKR:
						case RodzajZatrudnienia.Student:
						case RodzajZatrudnienia.Absolwent:
						case RodzajZatrudnienia.Chałupnik:
						case RodzajZatrudnienia.PracownikZaGranicą:
                        case RodzajZatrudnienia.PracownikTymczasowyZaGranicą:
                            //Agent
							break;
											
						case RodzajZatrudnienia.Właściciel:
						case RodzajZatrudnienia.OsobaWspółpracująca:
						case RodzajZatrudnienia.Uczeń1Klasy:
						case RodzajZatrudnienia.Uczeń2Klasy:
						case RodzajZatrudnienia.Uczeń3Klasy:
						case RodzajZatrudnienia.MłodocianyPrzyuczany:
							continue;
						
						default:
							throw new Exception("Nieoczekiwana wartość pola RodzajZatrudnienia: " + ph.Etat.RodzajZatrudnienia);
					}
			
					oz += ph.Etat.EfektywnyOkres;
				}
			oz = (oz * rokex).ToFlat();
			//W ogóle nie pracował
			if (oz==Periods.Empty)
				return;
            			
			bool begin = oz.Contains(rokex.From);
			bool beginN = begin && Nieobecny(pracownik, rokex.From.Year);
			bool end = !oz.Contains(rokex.To);
			bool endN = !end && Nieobecny(pracownik, rokex.To.Year);
			
			if (begin && !beginN)
				Inc(kobieta, ref poprzednio, ref poprzednioK);
			else {
				Inc(kobieta, ref przyjęci, ref przyjęciK);
                if (beginN)
					Inc(kobieta, ref zurlopu, ref zurlopuK);
				else {
					PracHistoria ph = pracownik[oz.From];
					
					if (ph.GUS.PierwszaPraca) {
						Inc(kobieta, ref pierwsza, ref pierwszaK);
						
						switch (ph.GUS.PopMiejsceZatrudnienia) {
							case PopMiejsceZatrudnienia.AbsolwentSzkołyWyższej:
								Inc(kobieta, ref wyższa, ref wyższaK); break;
							
							case PopMiejsceZatrudnienia.AbsolwentSzkołyPolicealnej:
							case PopMiejsceZatrudnienia.AbsolwentSzkołyŚredniejZawodowej:
								Inc(kobieta, ref policealna, ref policealnaK); break;
							
							case PopMiejsceZatrudnienia.AbsolwentLiceumOgólnokształcącego:
								Inc(kobieta, ref liceum, ref liceumK); break;
							
							case PopMiejsceZatrudnienia.AbsolwentSzkołyZasadniczej:
								Inc(kobieta, ref zasadnicza, ref zasadniczaK); break;
						}
					}
					else if (PoprzednioPracował(pracownik, oz.From-1))
						Inc(kobieta, ref pracował, ref pracowałK);
					else
						Inc(kobieta, ref pozostali, ref pozostaliK);
				}
			}
				
			if (endN || end) {
				Inc(kobieta, ref zwolnieni, ref zwolnieniK);
				if (endN)
					Inc(kobieta, ref naurlop, ref naurlopK);
				else {							
					PracHistoria ph = pracownik[oz.To];
					string s = ph.Etat.PrzyczynaRozwUmowy;
					if (s=="")
						s = "Nieokreślona przyczyna rozwiązania umowy";
					
					PrzyczynaRU pru = (PrzyczynaRU)przyczyny[s.ToUpper()];
					if (pru==null)
						przyczyny.Add(s.ToUpper(), pru = new PrzyczynaRU(s));
					pru.Add(ph);
				}
			}
		}
		
		bool PoprzednioPracował(Pracownik pracownik, Date data) {
			foreach (HistoriaZatrudnieniaBase hz in pracownik.HistoriaZatrudnienia)
				if (hz.Typ==TypHistoriiZatrudnienia.Zatrudnienie && hz.Okres!=FromTo.Empty)
					if (hz.Okres.Contains(data))
						return true;
					else if (hz.Okres.To<=data) {
						StazPracy sp = new StazPracy(new FromTo(hz.Okres.To-1, data), pracownik).Normalizuj();
						if (sp.Lata==0 && sp.Miesiace==0)
							return true;						
					}
			return false;
		}
    }

    void dc_ContextLoad(Object sender, EventArgs e) {
        ReportHeader["ROK"] = pars.Rok.ToString();
        FromTo rok = pars.Okres;

        KadryModule kadry = KadryModule.GetInstance(dc);

        ZatrudnienieWynagrodzenie zw = new ZatrudnienieWynagrodzenie(rok);
        Minimalne min = new Minimalne(pars.Rok);
        SkładnikiWynagrodzeń sw = new SkładnikiWynagrodzeń(rok);
        CzasPracy cp = new CzasPracy(rok);
        Pracujący31XII z1231 = new Pracujący31XII(rok.To.Year);
        ZatrudnieniZwolnieni zatrzw = new ZatrudnieniZwolnieni(rok);

        IEnumerable pracownicy;
        if (wglisty) {
            ArrayList lista = new ArrayList();
            foreach (Pracownik idx in (Row[])dc[typeof(Row[])])
                lista.Add(idx);
            pracownicy = lista;
        }
        else
            pracownicy = kadry.Pracownicy;

        foreach (Pracownik p in pracownicy) {
            foreach (PracHistoria ph in p.Historia.GetIntersectedRows(rok))
                zw.AddEtaty(ph);
            zw.AddBrutto(p);
            min.AddOsoba(p);
            sw.AddBrutto(p);
            cp.AddCzas(p);
            z1231.AddPracownik(p);
            zatrzw.AddPracownik(p);
        }

        etatyOgółem.EditValue = Etaty(zw.etaty);
        etatyRobotnicy.EditValue = Etaty(zw.er);
        etatyUczniowie.EditValue = Etaty(zw.eu);
        etatyZagranica.EditValue = Etaty(zw.ez);
        etatyInterwencyjni.EditValue = Etaty(zw.ei);

        bruttoOgółem.EditValue = Tys(zw.brutto);
        bruttoRobotnicy.EditValue = Tys(zw.br);
        bruttoUczniowie.EditValue = Tys(zw.bu);
        bruttoZagranica.EditValue = Tys(zw.bz);
        zus.EditValue = Tys(zw.zus);
        pit.EditValue = Tys(zw.pit);
        bruttoInterwencyjni.EditValue = Tys(zw.bi);

        osobyMin1.EditValue = min.min1;
        osobyMin2.EditValue = min.min2;
        osobyMin3.EditValue = min.min3;

        osobowe.EditValue = Tys(sw.brutto);
        nadliczbowe.EditValue = Tys(sw.nadliczbowe);
        chałupnicy.EditValue = Tys(sw.chałupnicy);
        zysk.EditValue = Tys(sw.zysk);
        budżet.EditValue = Tys(sw.budżet);
        umowy.EditValue = Tys(sw.umowy);
        honoraria.EditValue = Tys(sw.honoraria);
        prowizje.EditValue = Tys(sw.prowizje);

        ogółem.EditValue = Czas(cp.ogółem + cp.rogółem);
        rogółem.EditValue = Czas(cp.rogółem);
        nadlicz.EditValue = Czas(cp.nadlicz + cp.rnadlicz);
        rnadlicz.EditValue = Czas(cp.rnadlicz);
        nieobec.EditValue = Czas(cp.nieobec + cp.rnieobec);
        rnieobec.EditValue = Czas(cp.rnieobec);
        płatne.EditValue = Czas(cp.płatne + cp.rpłatne);
        rpłatne.EditValue = Czas(cp.rpłatne);
        urlopy.EditValue = Czas(cp.urlopy + cp.rurlopy);
        rurlopy.EditValue = Czas(cp.rurlopy);
        choroby.EditValue = Czas(cp.choroby + cp.rchoroby);
        rchoroby.EditValue = Czas(cp.rchoroby);

        pracujący.EditValue = z1231.pracujący + z1231.pracującyK;
        pracującyK.EditValue = z1231.pracującyK;
        główne.EditValue = z1231.główne + z1231.główneK;
        główneK.EditValue = z1231.główneK;
        pełnozatrudnieni.EditValue = z1231.pełnozatrudnieni + z1231.pełnozatrudnieniK;
        pełnozatrudnieniK.EditValue = z1231.pełnozatrudnieniK;
        niepełnozatrudnieni.EditValue = z1231.niepełnozatrudnieni + z1231.niepełnozatrudnieniK;
        niepełnozatrudnieniK.EditValue = z1231.niepełnozatrudnieniK;
        wlswsp.EditValue = z1231.wlswsp + z1231.wlswspK;
        wlswspK.EditValue = z1231.wlswspK;
        właściciele.EditValue = z1231.właściciele + z1231.właścicieleK;
        właścicieleK.EditValue = z1231.właścicieleK;
        nakładcza.EditValue = z1231.nakładcza + z1231.nakładczaK;
        nakładczaK.EditValue = z1231.nakładczaK;
        rsp.EditValue = z1231.rsp + z1231.rspK;
        rspK.EditValue = z1231.rspK;
        wnocnej.EditValue = z1231.wnocnej + z1231.wnocnejK;
        wnocnejK.EditValue = z1231.wnocnejK;
        niepełnosprawni.EditValue = z1231.niepełnosprawni + z1231.niepełnosprawniK;
        niepełnosprawniK.EditValue = z1231.niepełnosprawniK;
        cudzoziemcy.EditValue = z1231.cudzoziemcy + z1231.cudzoziemcyK;
        cudzoziemcyK.EditValue = z1231.cudzoziemcyK;
        emrent.EditValue = z1231.emrent + z1231.emrentK;
        emrentK.EditValue = z1231.emrentK;

        poprzednio.EditValue = zatrzw.poprzednio + zatrzw.poprzednioK;
        poprzednioK.EditValue = zatrzw.poprzednioK;
        przyjęci.EditValue = zatrzw.przyjęci + zatrzw.przyjęciK;
        przyjęciK.EditValue = zatrzw.przyjęciK;
        pierwsza.EditValue = zatrzw.pierwsza + zatrzw.pierwszaK;
        pierwszaK.EditValue = zatrzw.pierwszaK;
        wyższa.EditValue = zatrzw.wyższa + zatrzw.wyższaK;
        wyższaK.EditValue = zatrzw.wyższaK;
        policealna.EditValue = zatrzw.policealna + zatrzw.policealnaK;
        policealnaK.EditValue = zatrzw.policealnaK;
        liceum.EditValue = zatrzw.liceum + zatrzw.liceumK;
        liceumK.EditValue = zatrzw.liceumK;
        zasadnicza.EditValue = zatrzw.zasadnicza + zatrzw.zasadniczaK;
        zasadniczaK.EditValue = zatrzw.zasadniczaK;
        pracował.EditValue = zatrzw.pracował + zatrzw.pracowałK;
        pracowałK.EditValue = zatrzw.pracowałK;
        zurlopu.EditValue = zatrzw.zurlopu + zatrzw.zurlopuK;
        zurlopuK.EditValue = zatrzw.zurlopuK;
        pozostali.EditValue = zatrzw.pozostali + zatrzw.pozostaliK;
        pozostaliK.EditValue = zatrzw.pozostaliK;
        zwolnieni.EditValue = zatrzw.zwolnieni + zatrzw.zwolnieniK;
        zwolnieniK.EditValue = zatrzw.zwolnieniK;
        naurlop.EditValue = zatrzw.naurlop + zatrzw.naurlopK;
        naurlopK.EditValue = zatrzw.naurlopK;

        if (zatrzw.przyczyny.Count > 0) {
            string ss = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" border=\"1\" style=\"border-collapse: collapse; font-family: Verdana; font-size: 11px;\">";

            ArrayList lista = new ArrayList(zatrzw.przyczyny.Values);
            lista.Sort();
            foreach (PrzyczynaRU pz in lista) {
                ss += "<TR>";
                ss += string.Format("<TD width=\"50%\">{0}</TD>", pz.nazwa);
                ss += string.Format("<TD width=\"25%\" align=\"right\"><STRONG>{0}</STRONG></TD>", pz.razem);
                ss += string.Format("<TD width=\"25%\" align=\"right\"><STRONG>{0}</STRONG></TD>", pz.kobiety);
                ss += "</TR>";
            }

            ss += "</TABLE>";

            przyczyny.EditValue = ss;
        }
        else
            przyczyny.EditValue = "&nbsp;";

        if (z1231.miejsca.Count > 0) {
            string ss = "<TABLE cellSpacing=\"0\" cellPadding=\"0\" width=\"100%\" border=\"1\" style=\"border-collapse: collapse; font-family: Verdana; font-size: 11px;\">";
            ss += "<TR>";
            ss += "<TD width=\"45%\" align=\"center\">Nazwy miast, gmin i województw<br>Opis rodzaju działalności</TD>";
            ss += "<TD width=\"05%\" align=\"center\"><strong>1</strong>-miasto, <strong>2</strong>-wieś</TD>";
            ss += "<TD width=\"25%\" align=\"center\">Ogółem</TD>";
            ss += "<TD width=\"25%\" align=\"center\">W tym kobiety</TD>";
            ss += "</TR>";

            ArrayList lista = new ArrayList(z1231.miejsca.Values);
            lista.Sort();
            foreach (MiejscePracy mp in lista) {
                ss += "<TR>";
                if (mp.gmina == "") {
                    ss += "<TD width=\"45%\"><STRONG>Ogółem</STRONG> (dział 4 wiersz 02)</TD>";
                    ss += "<TD width=\"5%\">&nbsp;</TD>";
                }
                else {
                    ss += string.Format("<TD width=\"45%\">{0}<br>{1}</TD>", mp.gmina, mp.rodzaj);
                    ss += string.Format("<TD width=\"5%\" align=\"center\">{0}</TD>", mp.miasto ? 1 : 2);
                }
                ss += string.Format("<TD width=\"25%\" align=\"right\"><STRONG>{0}</STRONG></TD>", mp.razem);
                ss += string.Format("<TD width=\"25%\" align=\"right\"><STRONG>{0}</STRONG></TD>", mp.kobiety);
                ss += "</TR>";
            }

            ss += "</TABLE>";

            miejsca.EditValue = ss;
        }
        else
            miejsca.EditValue = "&nbsp;";
    }
    
    public decimal Etaty(decimal[] etaty) {
		decimal razem = 0m;
		foreach (decimal d in etaty)
			razem += d;
		razem /= etaty.Length;
		if (debug)
			return Soneta.Tools.Math.Round(razem, 2);
		return Soneta.Tools.Math.Round(razem, 0);
    }

    public decimal Tys(decimal value) {
		if (debug)
			return value;
		return Soneta.Tools.Math.Round(value/1000m, 1);
    }
    
    public object Czas(Time t) {
		if (debug)
			return t;
		return Soneta.Tools.Math.Round(t.TotalHours/1000.0, 1);
    }
    
    static void Msg(object value) {
    }

		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:datacontext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:datacontext>
			<eb:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader" title="Z-06 Sprawozdanie o pracujących, wynagrodzeniach i czasie pracy|</strong>Rok: <strong>%ROK%" runat="server"></eb:reportheader>
			<p>
			<font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 1. Zatrudnienie i wynagrodzenia</font>
				<TABLE id="Table1" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD align="center" width="50%" colSpan="3"><STRONG>Wyszczególnienie</STRONG></TD>
						<TD align="center" width="20%">Przeciętna liczba<BR>
								zatrudnionych</TD>
						<TD align="center">Wynagrodzenie brutto w tyś zł.<BR> (z jednym 
                            znakiem po przecinku)</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3">0</TD>
						<TD align="center">1</TD>
						<TD align="center">2</TD>
					</TR>
					<TR>
						<TD colSpan="2">Ogółem</TD>
						<TD align="center" width="5%">1</TD>
						<TD style="HEIGHT: 23px" align="right"><ea:datalabel id="etatyOgółem" runat="server"></ea:datalabel></TD>
						<TD style="HEIGHT: 23px" align="right"><ea:datalabel id="bruttoOgółem" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">w tym pracownicy na stanowiskach robotniczych i 
								pokrewnych</TD>
						<TD align="center">2</TD>
						<TD align="right"><ea:datalabel id="etatyRobotnicy" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="bruttoRobotnicy" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Osoby (uczniowe) zatrudnione na podstawie umowy o pracę 
								w celu przygotowania zawodowego</TD>
						<TD align="center">3</TD>
						<TD align="right"><ea:datalabel id="etatyUczniowie" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="bruttoUczniowie" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Osoby zatrudnione poza granicami kraju</TD>
						<TD align="center">4</TD>
						<TD align="right"><ea:datalabel id="etatyZagranica" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="bruttoZagranica" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD align="center" width="10%">Z wiersza 1</TD>
						<TD><FONT>składki na ubezpieczenie emerytalne, rentowe i chorobowe opłacone 
								przez ubezpieczonych</TD>
						<TD align="center">5</TD>
						<TD align="right">&nbsp;</TD>
						<TD align="right"><ea:datalabel id="zus" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>podatek dochodowy od osób fizycznych<BR>
								<STRONG>(przed odliczeniem składki na powszechne ubezpieczenie zdrowotne)</STRONG></TD>
						<TD align="center">6</TD>
						<TD align="right">&nbsp;</TD>
						<TD align="right"><ea:datalabel id="pit" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD><FONT>pracownicy zatrudnieni przy pracach interwencyjnych i robotach 
								publicznych</TD>
						<TD align="center">7</TD>
						<TD align="right"><ea:datalabel id="etatyInterwencyjni" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="bruttoInterwencyjni" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</p>
			<P>
				<TABLE id="Table2" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD width="45%"><FONT><STRONG>Liczba pracowników</STRONG> wg stanu na w dniu 
								31 XII otrzymujących w grudniu <STRONG>wynagrodzenie nieprzekraczające minimalnego 
									wynagrodzenia</STRONG> (Dz. U. z 2006 r. Nr 171, poz. 1227) - <STRONG>w osobach</STRONG></TD>
						<TD align="center" width="5%">8</TD>
						<TD>
							<TABLE id="Table3" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                                style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
								<TR>
									<TD align="center" width="33%">936,00 zł i mniej</TD>
									<TD colSpan="2">
										<TABLE id="Table4" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                                            style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
											<TR>
												<TD align="center" colSpan="2">w tym</TD>
											</TR>
											<TR>
												<TD align="center" width="50%">935,99 - 748,80 zł.</TD>
												<TD align="center">do 748,79 zł.</TD>
											</TR>
										</TABLE>
									</TD>
								</TR>
								<TR>
									<TD align="right"><ea:datalabel id="osobyMin1" runat="server"></ea:datalabel></TD>
									<TD align="right" width="33%"><ea:datalabel id="osobyMin2" runat="server"></ea:datalabel></TD>
									<TD align="right"><ea:datalabel id="osobyMin3" runat="server"></ea:datalabel></TD>
								</TR>
							</TABLE>
						</TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="PageBreak1" runat="server" Required="False"></ea:pagebreak>
			<P>
			    <font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 2. Składniki wynagrodzenia - brutto </font>
			    <font style="font-family: Verdana; font-size: 11px;"><i>(z jednym znakiem po przecinku)</i></font>
				<TABLE id="Table5" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD align="center" width="70%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center">W tyś. zł</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3">0</TD>
						<TD align="center">1</TD>
					</TR>
					<TR>
						<TD colSpan="2">Wynagrodzenie osobowe</TD>
						<TD align="center" width="5%">1</TD>
						<TD align="right"><ea:datalabel id="osobowe" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD align="center" width="10%">w tym</TD>
						<TD>za pracę w godzinach nadliczbowych</TD>
						<TD align="center">2</TD>
						<TD align="right"><ea:datalabel id="nadliczbowe" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>osób wykonujących pracę nakładczą</TD>
						<TD align="center">3</TD>
						<TD align="right"><ea:datalabel id="chałupnicy" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Wypłaty z tytułu udziału w zysku lub nadwyżce bilansowej 
								w spółdzielniach</TD>
						<TD align="center">4</TD>
						<TD align="right"><ea:datalabel id="zysk" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Dodatkowe wynagrodzenia roczne dla pracowników jednostek 
								sfery budżetowej</TD>
						<TD align="center">5</TD>
						<TD align="right"><ea:datalabel id="budżet" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Wynagrodzenia z tytułu umowy-zlecenia lub umowy o dzieło<BR>
								<EM>(wyngarodzenia bezosobowe)</EM></TD>
						<TD align="center">6</TD>
						<TD align="right"><ea:datalabel id="umowy" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Honoraria</TD>
						<TD align="center">7</TD>
						<TD align="right"><ea:datalabel id="honoraria" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Wynagrodzenia agencyjno-prowizyjne</TD>
						<TD align="center">8</TD>
						<TD align="right"><ea:datalabel id="prowizje" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="PageBreak2" runat="server" Required="False"></ea:pagebreak>
			<P><font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 3. 
                Czas pracy </font>
				<i><font style="font-family: Verdana; font-size: 11px;">(w tyś. godzin z jednym 
                znakiem po przecinku)</font></i>
				<TABLE id="Table6" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD align="center" width="50%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center" width="25%">Ogółem</TD>
						<TD align="center">W tym na stanowiskach robotniczych</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3">0</TD>
						<TD align="center">1</TD>
						<TD align="center">2</TD>
					</TR>
					<TR>
						<TD colSpan="2">Czas faktycznie przepracowany ogółem</TD>
						<TD align="center" width="5%">1</TD>
						<TD align="right"><ea:datalabel id="ogółem" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="rogółem" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">w tym w godzinach nadliczbowych</TD>
						<TD align="center">2</TD>
						<TD align="right"><ea:datalabel id="nadlicz" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="rnadlicz" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Czas nieprzepracowany ogółem</TD>
						<TD align="center">3</TD>
						<TD align="right"><ea:datalabel id="nieobec" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="rnieobec" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">w tym opłacony</TD>
						<TD align="center">4</TD>
						<TD align="right"><ea:datalabel id="płatne" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="rpłatne" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD align="center" width="10%">w tym z powodu:</TD>
						<TD>urlopów wypoczynkowych</TD>
						<TD align="center">5</TD>
						<TD align="right"><ea:datalabel id="urlopy" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="rurlopy" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>chorób</TD>
						<TD align="center">6</TD>
						<TD align="right"><ea:datalabel id="choroby" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="rchoroby" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="PageBreak3" runat="server" Required="False"></ea:pagebreak>
			<P><font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 4. Pracujący - stan w dniu 31 XII</font>
				<TABLE id="Table7" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD align="center" width="50%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center" width="25%">Ogółem</TD>
						<TD align="center">W tym kobiety</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3">0</TD>
						<TD align="center">1</TD>
						<TD align="center">2</TD>
					</TR>
					<TR>
						<TD colSpan="2">Pracujący ogółem</TD>
						<TD align="center" width="5%">01</TD>
						<TD align="right"><ea:datalabel id="pracujący" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pracującyK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">Pracujący, dla których jednostka 
									sprawozdawcza jest <STRONG>głównym</STRONG> miejscem pracy (w. 
									03+04+05+07+08+09)</TD>
						<TD align="center">02</TD>
						<TD align="right"><ea:datalabel id="główne" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="główneK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Pełnozatrudnieni <EM>(łącznie z 
										sezonowymi i zatrudnionymi dorywczo)</EM></TD>
						<TD align="center">03</TD>
						<TD align="right"><ea:datalabel id="pełnozatrudnieni" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pełnozatrudnieniK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Niepełnozatrudnieni</TD>
						<TD align="center">04</TD>
						<TD align="right"><ea:datalabel id="niepełnozatrudnieni" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="niepełnozatrudnieniK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Właściciele, współwłaściciele 
									łącznie z pomagającymi członkami ich rodzin</TD>
						<TD align="center">05</TD>
						<TD align="right"><ea:datalabel id="wlswsp" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="wlswspK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; w tym 
									właściciele i współwłaściciele</TD>
						<TD align="center">06</TD>
						<TD align="right"><ea:datalabel id="właściciele" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="właścicieleK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Osoby wykonujące pracę nakładczą</TD>
						<TD align="center">07</TD>
						<TD align="right"><ea:datalabel id="nakładcza" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="nakładczaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Agenci <EM>(bez agentów w administracji 
									samorządu terytorialnego - sołtysów)</EM></TD>
						<TD align="center">08</TD>
						<TD align="right">&nbsp;</TD>
						<TD align="right">&nbsp;</TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; Członkowie spółdzielni produkcji rolniczej 
								(RSP)</TD>
						<TD align="center">09</TD>
						<TD align="right"><ea:datalabel id="rsp" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="rspK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD align="center" width="10%">Z wiersza 02</TD>
						<TD>pracujący w porze nocnej</TD>
						<TD align="center">10</TD>
						<TD align="right"><ea:datalabel id="wnocnej" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="wnocnejK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>niepełnosprawni</TD>
						<TD align="center">11</TD>
						<TD align="right"><ea:datalabel id="niepełnosprawni" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="niepełnosprawniK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>cudzoziemcy</TD>
						<TD align="center">12</TD>
						<TD align="right"><ea:datalabel id="cudzoziemcy" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="cudzoziemcyK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>emeryci i renciści</TD>
						<TD align="center">13</TD>
						<TD align="right"><ea:datalabel id="emrent" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="emrentK" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="PageBreak4" runat="server" Required="False"></ea:pagebreak>
			<P><font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 5. Przyjęcia do pracy i zwolnienia z pracy pracowników 
					pełnozatrudnionych w głównym miejscu pracy</font>
				<TABLE id="Table8" cellSpacing="0" cellPadding="0" width="100%" border="1" 
                    style="border-collapse: collapse; font-family: Verdana; font-size: 11px;">
					<TR>
						<TD align="center" width="50%" colSpan="3">Wyszczególnienie</TD>
						<TD align="center" width="25%">Ogółem</TD>
						<TD align="center">W tym kobiety</TD>
					</TR>
					<TR>
						<TD align="center" colSpan="3">0</TD>
						<TD align="center">1</TD>
						<TD align="center">2</TD>
					</TR>
					<TR>
						<TD colSpan="2"><STRONG>Pełnozatrudnieni</STRONG><em> (bez sezonowych i 
									zatrudnionych dorywczo)</em> w dniu 31 XII <strong>2006 r.</strong></TD>
						<TD align="center" width="5%">01</TD>
						<TD align="right"><ea:datalabel id="poprzednio" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="poprzednioK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2"><STRONG>Przyjęci</STRONG> <EM>(pełnozatrudnieni)</EM> do 
								pracy <STRONG>w okresie</STRONG> od&nbsp;1 I do 31 XII <STRONG>roku sprawozdawczego</STRONG>
								<EM>(w. 03+08+09+10)</EM></TD>
						<TD align="center">02</TD>
						<TD align="right"><ea:datalabel id="przyjęci" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="przyjęciK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; osoby obejmujące pracę po raz pierwszy</TD>
						<TD align="center">03</TD>
						<TD align="right"><ea:datalabel id="pierwsza" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pierwszaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD align="center" width="10%">&nbsp;z wiersza 03 absolwenci</TD>
						<TD>szkół wyższych</TD>
						<TD align="center">04</TD>
						<TD align="right"><ea:datalabel id="wyższa" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="wyższaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>szkół policealnych i średnich zawodowych</TD>
						<TD align="center">05</TD>
						<TD align="right"><ea:datalabel id="policealna" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="policealnaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>liceów ogólnokształcących</TD>
						<TD align="center">06</TD>
						<TD align="right"><ea:datalabel id="liceum" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="liceumK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD>&nbsp;</TD>
						<TD>szkół zasadniczych</TD>
						<TD align="center">07</TD>
						<TD align="right"><ea:datalabel id="zasadnicza" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="zasadniczaK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; osoby, które poprzednio pracowały, a przerwa w pracy nie była dłuższa niż 1 miesiąc</TD>
						<TD align="center">08</TD>
						<TD align="right"><ea:datalabel id="pracował" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pracowałK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; osoby, które powróciły z urlopów 
								wychowawczych i bezpłatnych</TD>
						<TD align="center">09</TD>
						<TD align="right"><ea:datalabel id="zurlopu" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="zurlopuK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; pozostali przyjęci do pracy</TD>
						<TD align="center">10</TD>
						<TD align="right"><ea:datalabel id="pozostali" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="pozostaliK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2"><STRONG>Zwolnienie</STRONG><EM> (pełnozatrudnieni)</EM> z 
								pracy<STRONG>&nbsp; w okresie </STRONG>od 1 I do 31 XII <STRONG>roku 
									sprawozdawczego </STRONG><EM>(w. 12+13+14+15+16+17+18)</EM></TD>
						<TD align="center">11</TD>
						<TD align="right"><ea:datalabel id="zwolnieni" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="zwolnieniK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="2">&nbsp;&nbsp; osobym które otrzymały urlopy wychowawcze i 
								bezpłatne</TD>
						<TD align="center">17</TD>
						<TD align="right"><ea:datalabel id="naurlop" runat="server"></ea:datalabel></TD>
						<TD align="right"><ea:datalabel id="naurlopK" runat="server"></ea:datalabel></TD>
					</TR>
					<TR>
						<TD colSpan="5"><ea:datalabel id="przyczyny" runat="server"></ea:datalabel></TD>
					</TR>
				</TABLE>
			</P>
			<ea:pagebreak id="Pagebreak5" runat="server" Required="False"></ea:pagebreak>
			<P><font style="font-family: Verdana; font-size: 11px; font-weight: bold">Dział 7. 
                Pracujący w miastach i gminach w głównym miejscu pracy </font><i>
                <font style="font-family: Verdana; font-size: 11px; ">(łącznie z zatrudnionymi 
                za granicą)</font></i><font 
                    style="font-family: Verdana; font-size: 11px; font-weight: bold">. 
                Stan w dniu 31 XII</font><br />
                
				<ea:datalabel id="miejsca" runat="server"></ea:datalabel>
		    </P>
			<eb:reportfooter id="ReportFooter" runat="server" TheEnd="False"></eb:reportfooter>
		    <br />
		</form>
	</body>
</HTML>
